
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 07 10:08:53 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A facade for all QA Middleware ATPs for external application
   *
   *  \version ExtApp_ATP_main.c#1:csrc:1
   *  \author 
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/***** Include Files **************/

#include "CRYS.h"

#include "MW_ATP_defines.h"
#include "MW_ATP_define_flags.h"
#include "MW_ATP_UTIL_funcs.h"
#include "DX_VOS_Stdio.h"


/******** Defines ************/

/******** Enums ************/
/******** Typedefs ***********/
/******** Global Data **********/
/******** Private Functions ******/

/*****************************************************************************
* Function Name:                                                           
*  Ext_ATP_TST_RunAllATPs      
*  
* Inputs:
*  TST_KeyGeneration_flag - A parameter defining if to run the test with 
*                           internal key generation TST_INTERNAL_KG - Run the 
*                           test with internal key generation and external keys
*							TST_NO_INTERNAL_KEYGEN  - Run the test with external 
*							key only - NO keyGen
*
* Outputs:
*  DxError_t - Function error return
*
* Description:                                                                 
*  This function runs all the ATPs tests for external user application
*  
*******************************************************************************/

DxError_t Ext_ATP_TST_RunAllATPs(DxUint32_t TST_KeyGeneration_flag)
{
    DxError_t TST_ATP_Error = DX_SUCCESS;
    
    DxUint32_t TST_FailedTestsFlags = 0;
    /* a bit-map with flags of failure of every ATP test */
    
    DxUint32_t TST_TestsNum = 0;
    /* current test index */
    
    #ifndef CRYS_NO_EXT_APP_CRYS_SUPPORT
    TST_ATP_Error = CRYS_Ext_ATP_TST_RunAllAcceptance_tests(TST_KeyGeneration_flag);
    TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
    TST_TestsNum++;
    #endif
    
    #ifndef CRYS_NO_EXT_APP_SST_SUPPORT
    TST_ATP_Error = SST_Ext_ATP_TST_Run_All_ATP_Tests();
    TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
    TST_TestsNum++;
    #endif
    
    #ifndef CRYS_NO_EXT_APP_KMNG_SUPPORT
    TST_ATP_Error = KMNG_ExtAPP_ATP_Run_All_ATP_Tests();
    TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
    TST_TestsNum++;
    #endif

    /*Check if all tests passed*/
    if (TST_FailedTestsFlags > 0)
    {
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
		ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!!       SOME ATP TESTS FAILED    :@     0x%03X   !!!!!!!!!!\n",TST_FailedTestsFlags));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    }
    else
    {
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n \n#'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`#\n"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"#'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`#\n"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"#'`~      ALL OF THE EXTERNAL APPLICATION ACCEPTANCE TESTS PASSED  :)  :P  :D    ~`#\n"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"#'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`#\n"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"#'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`#\n"));					
    }	
    return TST_ATP_Error;
		
}

/******** Public Functions *********/

 /*****************************************************************************
* Function Name:                                                           
*  EXTApp_ATP_menu      
*  
* Inputs:
*  
*
* Outputs:
*  
*
* Description:                                                                 
*  This is the menu for external application ATP tests 
*  
*******************************************************************************/
 
DxError_t EXTApp_ATP_menu ()
{

    DxUint8_t Var;
    do
    {
        do
        {
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n\n           -- DISCRETIX LTD 2007 --              "));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       -- Acceptance tests Ver -  06.03.00 --        "));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n---[ Main Tests Menu ]-------------------------------"));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));

            #ifndef CRYS_NO_EXT_APP_CRYS_SUPPORT
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [1] - CRYS          Tests                          "));
            #endif
            #ifndef CRYS_NO_EXT_APP_SST_SUPPORT
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [2] - SST           Tests                          "));
            #endif
            #ifndef CRYS_NO_EXT_APP_KMNG_SUPPORT
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [3] - KMNG          Tests                          "));
            #endif
            
            
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
            
            
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [T] - Run all Acceptance Tests for external application            "));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       [with internal KeyGeneration for RSA & ECC]   "));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [S] - Run all Acceptance Tests  for external application           "));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       [without internal KeyGeneration for RSA & ECC]"));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [Z] - End of tests                                  "));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-------------------------------------------------\n\n"));
            
            GET_NON_WHITE_SPACE_CHAR(Var);
            
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n Test = %c\n",Var));
            if (Var<='Z')
                break;
            else
            {
                    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
            }
        }while(1);

        switch(Var)
        {
            #ifndef CRYS_NO_EXT_APP_CRYS_SUPPORT
            case '1':
                    TST_ATP_Error = CRYS_ExtApp_ATP_menu();
                    break;
            #endif                    
            
            #ifndef CRYS_NO_EXT_APP_SST_SUPPORT
            case '2':
                    TST_ATP_Error = SST_ExtApp_ATP_menu();
                    break;
            #endif
            
            #ifndef CRYS_NO_EXT_APP_KMNG_SUPPORT                    
            case '3':
                    TST_ATP_Error = KMNG_ExtApp_ATP_menu();
                    break;
            #endif
                                
            case 'T':
                    TST_ATP_Error = Ext_ATP_TST_RunAllATPs(TST_INTERNAL_KG);
                    break;
            case 'S':
                    TST_ATP_Error = Ext_ATP_TST_RunAllATPs(TST_NO_INTERNAL_KEYGEN);
                    break;
            case 'Z':
                    DX_VOS_Printf("\n End of MW ATP tests \n");
                    break ;
            default:
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n* Error in test selection [%c]ASCII(%d)\n",Var,(DxUint32_t)Var));
        }
        if(Var =='Z')
        break;
    }while (1);

    
    return TST_ATP_Error;
    
 }/* End of Ext_ATP_menu*/

